# UNIX.mk 2.9.0 92/07/06 -- Makefile for mff -- UNIX version

#  make all 
#	to create progs this directory

#  make install IBIN=/usr/local/bin OPT=-O4 LDFLAGS=-s
#	to do "make all" and then copy progs into $(IBIN).

SUFFIX=
#  Suffix added to .o and .a file basenames

#  MACROS THAT GO INTO THE cc COMMAND

OPT=-O
NDEBUG=-DNDEBUG
CFLAGS=$(OPT)

RCDIR=/mclab/pdc/lib
#  RCDIR is the directory in which  the "system-wide" rc.mff file is 
#  to be found.  
#  The default -- if the above line is commented out --
#  is the value in config.h; by default /usr/local/lib.

CPPFLAGS=$(NDEBUG) $(MORECPPFLAGS)
LDFLAGS=

CP=cp -p
RM=rm -f

#  Tell "make" how to do compilations
#  -- removed Sun's silly -target option which confuses gcc.
COMPILE=$(CC) $(CFLAGS) $(CPPFLAGS) -c
LINK=$(CC) $(CFLAGS) $(CPPFLAGS) $(LDFLAGS)

.SUFFIXES: $(SUFFIX).o
.c$(SUFFIX).o:
	$(COMPILE) -o $@ $<
.c.o:
	$(COMPILE) -o $@ $<

IBIN=/mclab/pdc/tmp
ILIB=/mclab/pdc/tmp

########################################################################
#
#	TARGETS for the make command...

PROGS=mff.c searchpath.c
# source files for executables

LIBFILE=libargloop$(SUFFIX).a
LIB=$(LIBFILE)
.PRECIOUS: $(LIB)

MODULES=argloop.c al_file.c al_init.c findfile.c \
	strword.c stritem.c strdup.c fgetword.c error.c
# source files for modules in the argloop library

all: $(PROGS:.c=)
install: all install-lib
	$(CP) $(PROGS:.c=) $(IBIN)	
install-lib: $(LIB)
	$(CP) $(LIB) $(ILIB)

debug:
	$(MAKE) all SUFFIX=-g OPT=-g LDFLAGS= NDEBUG= "CC=gcc -Wall"
install-lib-g:
	$(MAKE) install-lib \
		SUFFIX=-g OPT=-g LDFLAGS= NDEBUG= "CC=gcc -Wall"
clean: 
	$(RM) *.ln *.o $(PROGS:.c=) *.a

########################################################################


MFF_o=mff$(SUFFIX).o assoc$(SUFFIX).o fx$(SUFFIX).o magstep$(SUFFIX).o
MFF_lib=$(LIB)
mff: $(MFF_o) $(LIB)
	$(LINK) -o mff $(MFF_o) $(MFF_lib)

SEARCHPATH_o=searchpath$(SUFFIX).o
SEARCHPATH_lib=$(LIB)
searchpath: $(SEARCHPATH_o) $(LIB)
	$(LINK) -o searchpath $(SEARCHPATH_o) $(SEARCHPATH_lib)

mff$(SUFFIX).o:	mff.c stdc.h config.h xstdio.h argloop.h fatal.h searchpath.h \
  		assoc.h fx.h strmisc.h magstep.h
assoc$(SUFFIX).o:	assoc.c stdc.h config.h xstdio.h strmisc.h assoc.h
fx$(SUFFIX).o:		fx.c stdc.h config.h xstdio.h fatal.h strmisc.h fx.h
magstep$(SUFFIX).o:	magstep.c stdc.h config.h magstep.h
searchpath$(SUFFIX).o:	searchpath.c xstdio.h stdc.h config.h searchpath.h

# semi-automatically-produced dependencies:

al_file.o:	al_file.c config.h xstdio.h stdc.h strmisc.h argloop.h
al_init.o:	al_init.c config.h xstdio.h stdc.h strmisc.h argloop.h
argloop.o:	argloop.c config.h xstdio.h stdc.h strmisc.h argloop.h
error.o:	error.c stdc.h config.h xstdio.h argloop.h fatal.h
fgetword.o:	fgetword.c xstdio.h stdc.h config.h
findfile.o:	findfile.c config.h strmisc.h stdc.h searchpath.h
strdup.o:	strdup.c fatal.h stdc.h config.h strmisc.h
stritem.o:	stritem.c strmisc.h stdc.h config.h
strword.o:	strword.c strmisc.h stdc.h config.h

config.h: config.x
	sed 's%/usr/local/lib%$(RCDIR)%' config.x > config.h

########################################################################
#	LIBRARY

# source for modules that go in the library

$(LIB): $(LIB)(argloop.o) $(LIB)(al_file.o) $(LIB)(al_init.o) \
		$(LIB)(findfile.o) $(LIB)(strword.o) $(LIB)(stritem.o) \
		$(LIB)(strdup.o) $(LIB)(fgetword.o) $(LIB)(error.o)

#  default rule
.c.a:
	$(COMPILE) -o $% $<
	$(AR) $(ARFLAGS) $@ $%
	$(RM) $%
	ranlib $@

#  I can't get @#$%& make to reliably ranlib after adding one or more
#  modules, so I have to make it do so every time.
#  COmment out this line on non-ranlib systems (Sys V?)

########################################################################
#	LINT SECTION (moan, moan)
#
#  sun's lint libraries often seem inconsistent with the manual pages 
#  and with reality.  
#
#  -n -lbsd -lm (BSD-compatibility check)
#    -- sprintf is given return type int not char * (!!)
#    -- void functions are given return type int
#    -- toupper is not defined
#  -lm -q (SunOS check)
#    -- errno is not defined

CFILES=$(PROGS)
LINTFILES=$(PROGS:.c=.ln)
LINTFLAGS=-abh
LINTLIB=llib-lmff.ln
LINTLIBS=-n -lbsd -lm
#LINTLIBS=-q -lm
LINTGREP=egrep -v 'constant (argument to NOT|in conditional context)'

lint: lint-mff lint-searchpath

lint-%: %.c $(LINTLIB)
	$(LINT.c) $*.c $(LINTLIB) $(LINTLIBS) | $(LINTGREP)

$(LINTLIB): $(MODULES:.c=.ln)
	$(LINT.c) -Cmff $(MODULES)
