/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;

public class PreferencesListener
implements ActionListener {
    private DviMain m_Source;
    private static final int[] m_Sizes = new int[]{2384, 2835, 1684, 2384, 1190, 1684, 842, 1190, 595, 842, 420, 595, 298, 420, 209, 298, 914, 1262, 667, 914, 2835, 4008, 2004, 2835, 1417, 2004, 1001, 1417, 709, 1001, 499, 709, 354, 499, 249, 354, 176, 249, 125, 176, 88, 125, 1837, 578, 578, 919, 919, 649, 649, 459, 459, 323, 3090, 2186, 3628, 2551, 2551, 1814, 1814, 1276, 1276, 907, 907, 638, 2438, 3458, 1729, 2438, 1219, 1729, 612, 792, 612, 1008, 792, 1224, 1224, 792, 522, 756, 954, 1188, 1044, 1332, 954, 1584, 954, 1782, 1116, 1440, 1188, 1512, 1260, 1584, 1296, 1656, 1368, 1728, 1440, 1800, 1584, 2160};
    private static final String[] sizeNames = new String[]{"A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A3Extra", "A4Extra", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "B10", "C2", "C3", "C4", "C5", "C6", "D0", "SRA0", "SRA1", "SRA2", "SRA3", "SRA4", "RA0", "RA1", "RA2", "USLetter", "USLegal", "USLedger", "USTabloid", "USExecutive", "Foolscap", "SmallPost", "Sheet3cap", "Sheet2cap", "Demy", "LargePost", "SmallMedium", "Medium", "SmallRoyal", "Royal", "Imperial"};

    public PreferencesListener(DviMain dviMain) {
        this.m_Source = dviMain;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DviMain.getResourceString("main.Font.label"))) {
            this.findBaKoMaFontFile();
            return;
        }
        if (string.equals(DviMain.getResourceString("main.Preferences.label"))) {
            return;
        }
        if (this.getPaperSize(string)) {
            return;
        }
    }

    private void findBaKoMaFontFile() {
        JFileChooser jFileChooser = new JFileChooser();
        File file = new File(DviMain.getResourceString("FontFile"));
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        DviFontFileFilter dviFontFileFilter = new DviFontFileFilter();
        jFileChooser.addChoosableFileFilter(dviFontFileFilter);
        jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter(dviFontFileFilter);
        int n = jFileChooser.showOpenDialog(this.m_Source);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.m_Source.setProperty("FontFile", file2.getAbsolutePath());
        }
    }

    private boolean getPaperSize(String string) {
        int n = 0;
        while (n < sizeNames.length) {
            String string2 = DviMain.getResourceString("paperSize." + sizeNames[n] + ".label");
            if (string2 != null && string2.equals(string)) {
                this.m_Source.setPaperSize(m_Sizes[2 * n], m_Sizes[2 * n + 1]);
                return true;
            }
            ++n;
        }
        return false;
    }
}

