/*
 ** Dialog to do a search and force a selection
 */
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

public class FindDialog extends Dialog implements TextListener, ActionListener
{
    private TextField m_queryField;
    private Checkbox m_key, m_data, m_forward, m_backward, m_matchCase;
    private Button m_find, m_close, m_show, m_cancel;
    // data information
    private Hashtable m_Index; // index
    private String[] m_Keys; // keys
    private RandomAccessFile m_RAFile; // file for searching
    private String m_Start; // position to start
    private ListFrame m_Parent; // list frame from which search originated

    private static boolean m_Debug;

    FindDialog(Frame f)
    {
        super(f, "Find Dialog", true);
        setDebug(false);
        setBackground(Color.lightGray);
        Panel topPan = new Panel(new FlowLayout());
        Label lab = new Label("Query Text");
        topPan.add(lab);
        m_queryField = new TextField(40);
        m_queryField.setBackground(Color.white);
        m_queryField.addTextListener(this);
        topPan.add(m_queryField);
        // buttons and check boxes
        Panel midPan = new Panel(new GridLayout(0,3));
        m_matchCase = new Checkbox("Match Case");
        midPan.add(m_matchCase);
        CheckboxGroup cbg = new CheckboxGroup();
        m_forward = new Checkbox("Forward", cbg, true);
        midPan.add(m_forward);
        m_backward = new Checkbox("Backward", cbg, false);
        midPan.add(m_backward);
        Panel botPan = new Panel(new GridLayout(0,2));
        m_find = new Button("Find");
        m_find.setEnabled(false);
        m_find.addActionListener(this);
        botPan.add(m_find);
        m_cancel = new Button("Close");
        m_cancel.addActionListener(this);
        botPan.add(m_cancel);
        // put together
        add("North", topPan);
        add("Center", midPan);
        add("South", botPan);
        pack();
        // position the dialog
        center(f);
        // set initial stuff
        m_RAFile = null;
        m_Start = null;
        m_Keys = null;
        m_Index = null;
    }

    /**
     Store a reference to a list of labels.
     */
    public void setList(String[] list) {
        m_Keys = list;}

    /**
     Store a reference to the index for the list.
     */
    public void setIndex(Hashtable index) {
        m_Index = index;}

    /**
     Store a reference to the file being worked on
     */
    public void setFile(RandomAccessFile file) {
        m_RAFile = file;}

    /**
     Set the item to start from.
     */
    public void setItem(String item) {
        m_Start = item;}

    /**
     Get the item which satisfies this search, or null if there is no match
     */
    public String getItem() {
        return m_Start;}

    /**
     Set the parent where items displayed.
     */
    public void setParent(ListFrame parent) {
        m_Parent = parent;}

/*    {
        return m_keepChanges;
    }

//    public void setList(RecList list)
//    {
//        m_list = list;
//    }

    public int getLocatedIndex()
    {
        return m_active;
    }

    public void setLocatedIndex(int located)
    {
        m_active = located;
    }

//    public void setListFrame(ListFrame lf)
//    {
//        m_listFrame = lf;
//    }
    
    /*
     ** center(Container over) centers the dialog over the passed
     ** container
     */
    public void center(Container over)
    {
        if(over.isVisible())
        {
            int width = getSize().width;
            int height = getSize().height;
            setSize(width, height);
            int parentScreenX = over.getLocationOnScreen().x;
            int parentScreenY = over.getLocationOnScreen().y;
            int parentWidth = over.getBounds().width;
            int parentHeight = over.getBounds().height;
            int screenX = Math.max(0, parentScreenX + parentWidth / 2 - width / 2);
            int screenY = Math.max(0, parentScreenY + parentHeight / 2 - height / 2);
            setLocation(screenX, screenY);
        }
    }
    /*
     ** text event listener in order to set buttons correctly
     */
    public void textValueChanged(TextEvent evt) {
        if(evt.getSource().equals(m_queryField)) {
            if(m_queryField.getText().length() > 0) {
                if(!m_find.isEnabled()) {
                    m_find.setEnabled(true);}}
            if(m_queryField.getText().length() == 0) {
                if(m_find.isEnabled()) {
                    m_find.setEnabled(false);}}}
    }
    
    /*
     ** catch item state changed, to get check boxes
     */
/*    public void itemStateChanged(ItemEvent evt)
    {
        if(evt.getSource().equals(m_key) || evt.getSource().equals(m_data))
        {
            if(((!m_key.getState()) && (!m_data.getState())) || (m_queryField.getText().length() == 0))
            {
                if(m_find.isEnabled())
                {
                    m_find.setEnabled(false);
                }
            }
            else
            {
                if(!m_find.isEnabled())
                {
                    m_find.setEnabled(true);
                }
            }
        }
    }

    /**
     Find the location of a string in an array of strings, returning -1
     if that element is not found.
     */
    public int findArrayPos(String[] list, String item) {
        for(int i=0; i<list.length; i++) {
            if(list[i].equals(item)) return i;}
        return -1;
    }

    /**
     action listener, to catch what is happening to the buttons
     */
    public void actionPerformed(ActionEvent evt) {
        if(evt.getSource().equals(m_cancel)) {
            // cancel button hit
            m_Start = null;
            setVisible(false);}
        else if(evt.getSource().equals(m_find)) {
            // find button hit, check if conditions O.K.
            if((m_Index == null) || (m_Keys == null) || (m_RAFile == null)) {
                m_Start = null;
                return;}
            // get the starting position.  Set to zero if not found
            int startPos = findArrayPos(m_Keys, m_Start);
            if(startPos < 0) startPos = 0;
            // check starting position.  Note, should also check to see that
            // the array of indices to choose from contains the starting
            // position.
            if(!m_Index.containsKey(m_Start)) {
                // choose another starting point
                m_Start = null;
                return;}
            // now do the actual search
            debug("Start of search: " + startPos + ": " + m_Start);
            if(m_forward.getState()) {
                // set flag for exit
                boolean flag = true;
                while(flag) {
                    // do the forward search
                    if(startPos < m_Keys.length-1) {
                        // move to next position
                        startPos++;
                        m_Start = m_Keys[startPos];
                        debug(startPos + ": " + m_Start);
                        // test the position
                        flag = !testRecord(m_Start);
                        if(!flag) break;
                    }
                    // if here, then have hit end.  Ask if continue from
                    // beginning.
                    else {
                        flag = AskDialog.createAskDialog("Expression not found before end of list.  Continue from beginning?"
                                                         , "Continue", "Exit", this);
                        // reset counter for starting
                        if(flag) {
                            startPos = -1;
                            m_Start = m_Keys[0];}}}}
            else {
                // do the backward search
                boolean flag = true;
                while(flag) {
                    // do the forward search
                    if(startPos > 0) {
                        // move to next position
                        startPos--;
                        m_Start = m_Keys[startPos];
                        debug(startPos + ": " + m_Start);
                        // test the position
                        flag = !testRecord(m_Start);
                        if(!flag) break;
                    }
                    // if here, then have hit end.  Ask if continue from
                    // beginning.
                    else {
                        flag = AskDialog.createAskDialog("Expression not found before start of list.  Continue from end?"
                                                         , "Continue", "Exit", this);
                        // reset counter for starting
                        if(flag) {
                            startPos = m_Keys.length;
                            m_Start = m_Keys[startPos - 1];}}}}
            // if we get this far, then we will want to set the record
            // in the list
            m_Parent.readRecordToEdit(m_Start);
        }
    }

    /**
     test the record from the file.
     */
    public boolean testRecord(String key) {
        // first position the pointer
        if(!m_Index.containsKey(key)) return false;
        String[] data = (String[])m_Index.get(key);
        try {
            m_RAFile.seek(Long.valueOf(data[ListFrame.FILE_POS]).longValue());
            // read in the record
            BibTeXRecord rec = new BibTeXRecord();
            rec.read(m_RAFile);
            // test the record
            if(m_matchCase.getState()) {
                return rec.containsText(m_queryField.getText());}
            return rec.containsTextIgnoreCase(m_queryField.getText());}
        catch(IOException e) {
            debug(e.toString());}
        return false;
    }

    /**
     Method to output a string when a debug flag is set
     */
    public static void debug(String message)
    {
        if(m_Debug) System.out.println("FindDialog:"+message);}

    /**
     Method to set the debug flag
     */
    public static void setDebug(boolean flag) {m_Debug = flag;}
}
